/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.questtypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiQuestEdit;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.quests.QuestObjective;

public class GuiNpcQuestTypeManual
extends SubGuiInterface
implements ITextfieldListener {
    private final QuestObjective task;
    private final Map<Integer, Integer> dataDimIDs = new HashMap<Integer, Integer>();

    public GuiNpcQuestTypeManual(EntityNPCInterface npc, QuestObjective taskObj, GuiScreen gui) {
        super(npc);
        this.setBackground("menubg.png");
        this.title = new TextComponentTranslation("quest.title.manual", new Object[0]).func_150254_d();
        this.xSize = 214;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.parent = gui;
        this.task = taskObj;
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guibutton) {
        if (!(guibutton instanceof GuiNpcButton)) {
            super.func_146284_a(guibutton);
            return;
        }
        if (this.task == null) {
            return;
        }
        GuiNpcButton button = (GuiNpcButton)guibutton;
        switch (guibutton.field_146127_k) {
            case 4: {
                if (!this.dataDimIDs.containsKey(button.getValue())) {
                    return;
                }
                this.task.dimensionID = this.dataDimIDs.get(button.getValue());
                button.setHoverText(new TextComponentTranslation("quest.hover.compass.dim", new Object[]{"" + this.task.dimensionID}).func_150257_a((ITextComponent)new TextComponentTranslation("quest.hover.compass", new Object[0])).func_150254_d(), new Object[0]);
                break;
            }
            case 5: {
                this.task.setPointOnMiniMap(((GuiNpcCheckBox)guibutton).isSelected());
                break;
            }
            case 10: {
                this.task.pos = new BlockPos(Math.floor(this.field_146297_k.field_71439_g.field_70165_t), Math.floor(this.field_146297_k.field_71439_g.field_70163_u), Math.floor(this.field_146297_k.field_71439_g.field_70161_v));
                this.task.dimensionID = this.field_146297_k.field_71439_g.field_70170_p.field_73011_w.getDimension();
                this.func_73866_w_();
                break;
            }
            case 11: {
                Client.sendData(EnumPacketServer.TeleportTo, this.task.dimensionID, this.task.pos.func_177958_n(), this.task.pos.func_177956_o(), this.task.pos.func_177952_p());
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.subgui == null) {
            int u = this.guiLeft + this.xSize - 1;
            int v = this.guiTop;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.background);
            this.func_73729_b(u, v, 252, 0, 4, this.ySize);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int lId = 0;
        int x = this.guiLeft + 6;
        int y = this.guiTop + 50;
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("quest.manual.names", new Object[0]).func_150254_d(), x, y));
        GuiNpcTextField textField = new GuiNpcTextField(0, this, this.field_146289_q, x, y += 12, 180, 20, this.task.getTargetName());
        textField.setHoverText("quest.hover.edit.kill.name", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(1, this, this.field_146289_q, x + 182, y, 24, 20, this.task.getMaxProgress() + "");
        textField.setMinMaxDefault(1L, Integer.MAX_VALUE, 1L);
        textField.setHoverText("quest.hover.edit.kill.value", "2147483647");
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "quest.task.pos.set", x, y += 24));
        this.addLabel(new GuiNpcLabel(lId++, "X:", x, (y += 12) + 2));
        TextComponentTranslation compass = new TextComponentTranslation("quest.hover.compass", new Object[0]);
        textField = new GuiNpcTextField(10, this, this.field_146289_q, x + 8, y, 40, 14, "" + this.task.pos.func_177958_n());
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.pos.func_177958_n());
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"X"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "Y:", x + 52, y + 2));
        textField = new GuiNpcTextField(11, this, this.field_146289_q, x + 60, y, 40, 14, "" + this.task.pos.func_177956_o());
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.pos.func_177956_o());
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"Y"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "Z:", x + 104, y + 2));
        textField = new GuiNpcTextField(12, this, this.field_146289_q, x + 112, y, 40, 14, "" + this.task.pos.func_177952_p());
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.pos.func_177952_p());
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.pos", new Object[]{"Z"}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "R:", x + 156, y + 2));
        textField = new GuiNpcTextField(14, this, this.field_146289_q, x + 164, y, 41, 14, "" + this.task.rangeCompass);
        textField.setMinMaxDefault(0L, 64L, this.task.rangeCompass);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.range", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "D:", x, (y += 20) + 2));
        int p = 0;
        int i = 0;
        List<Integer> ids = Arrays.asList(DimensionManager.getStaticDimensionIDs());
        Collections.sort(ids);
        String[] dimIDs = new String[ids.size()];
        for (int id : ids) {
            dimIDs[i] = id + "";
            this.dataDimIDs.put(i, id);
            if (id == this.task.dimensionID) {
                p = i;
            }
            ++i;
        }
        GuiNpcButton button = new GuiNpcButton(4, x + 8, y - 1, 30, 16, dimIDs, p);
        button.setHoverText(new TextComponentTranslation("quest.hover.compass.dim", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId, "P:", x + 40, y + 2));
        textField = new GuiNpcTextField(9, this, this.field_146289_q, x + 47, y, 32, 14, "" + this.task.regionID);
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.task.regionID);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.reg", new Object[]{this.task.regionID}).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "N:", x + 81, y + 2));
        textField = new GuiNpcTextField(15, this, this.field_146289_q, x + 89, y, 116, 14, this.task.entityName);
        textField.setHoverText(new TextComponentTranslation("quest.hover.compass.entity", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(10, x + 146, y += 19, 30, 20, "gui.set");
        button.setHoverText(new TextComponentTranslation("quest.hover.compass.set", new Object[0]).func_150257_a((ITextComponent)compass).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(11, x + 124, y, 20, 20, "TP");
        button.setHoverText("hover.teleport", new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(5, x, y, 121, 16, "quest.set.minimap.point", null, this.task.isSetPointOnMiniMap());
        button.setHoverText("quest.hover.set.minimap.point", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, x, this.guiTop + this.ySize - 25, 98, 20, "gui.back");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void save() {
        this.task.setTargetName(this.getTextField(0).getFullText());
        this.task.setMaxProgress(this.getTextField(1).getInteger());
        for (QuestObjective taskObj : NoppesUtilServer.getEditingQuest((EntityPlayer)this.player).questInterface.tasks) {
            if (taskObj == this.task || taskObj.getEnumType() != EnumQuestTask.MANUAL || !taskObj.getTargetName().equals(this.task.getTargetName())) continue;
            this.getTextField(0).setFullText("");
            this.task.setTargetName("");
            this.task.setMaxProgress(1);
            break;
        }
        if (this.task.getTargetName().isEmpty()) {
            NoppesUtilServer.getEditingQuest((EntityPlayer)this.player).questInterface.removeTask(this.task);
        } else if (((GuiNPCManageQuest)GuiNPCManageQuest.Instance).subgui instanceof GuiQuestEdit) {
            GuiQuestEdit subgui = (GuiQuestEdit)((GuiNPCManageQuest)GuiNPCManageQuest.Instance).subgui;
            subgui.setSubGui(null);
            subgui.func_73866_w_();
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.task == null) {
            return;
        }
        switch (textField.getID()) {
            case 0: {
                this.task.setTargetName(textField.getFullText());
                break;
            }
            case 1: {
                this.task.setMaxProgress(textField.getInteger());
                break;
            }
            case 2: {
                this.task.setAreaRange(textField.getInteger());
                break;
            }
            case 9: {
                if (!BorderController.getInstance().regions.containsKey(textField.getInteger())) {
                    textField.setFullText("" + textField.getDefault());
                    return;
                }
                this.task.regionID = textField.getInteger();
                textField.setHoverText(new TextComponentTranslation("quest.hover.compass.reg", new Object[]{"" + this.task.regionID}).func_150257_a((ITextComponent)new TextComponentTranslation("quest.hover.compass", new Object[0])).func_150254_d(), new Object[0]);
                break;
            }
            case 10: {
                this.task.pos = new BlockPos(textField.getInteger(), this.task.pos.func_177956_o(), this.task.pos.func_177952_p());
                break;
            }
            case 11: {
                this.task.pos = new BlockPos(this.task.pos.func_177958_n(), textField.getInteger(), this.task.pos.func_177952_p());
                break;
            }
            case 12: {
                this.task.pos = new BlockPos(this.task.pos.func_177958_n(), this.task.pos.func_177956_o(), textField.getInteger());
                break;
            }
            case 14: {
                this.task.rangeCompass = textField.getInteger();
                break;
            }
            case 15: {
                this.task.entityName = textField.getFullText();
            }
        }
    }
}

